<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" extension-element-prefixes="xlate" version="1.0">
  <xsl:param name="mode" select="'deploy'" />
  <xsl:template name="head">
    <link href="{$path_design}css/main.css" rel="stylesheet" type="text/css" />
	<link href="{$path_design}css/nivo-slider.css" rel="stylesheet"  type="text/css" media="screen" />
    <link href="{$path_design}css/colorbox-white.css" rel="stylesheet" type="text/css" />	
    	<script src="{$path_design}js/jquery.min.js" type="text/javascript"></script>
        <script type="text/javascript">
            $.noConflict();
        </script>
    	<script src="{$path_design}js/jquery.colorbox-min.js" type="text/javascript"></script>
    	<!--<script src="{$path_design}js/cufon.js" type="text/javascript"></script>-->
    	<script src="{$path_design}js/application.js" type="text/javascript"></script>
    <xsl:call-template name="iePNGFixHTC">
      <xsl:with-param name="selector">body,img,div</xsl:with-param>
      <xsl:with-param name="skipTileBg">false</xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="document">
    <xsl:param name="layoutclass" select="''" />
    <div class="sichtbar" id="page_wrapper">
      <div id="social_wrapper">
        <div id="social">
          <a href="http://www.facebook.com/zeranka.ruhpolding" id="facebook" target="_blank" title="Facebook">Facebook</a>
          <a href="http://www.twitter.com" id="twitter" target="_blank" title="Twitter">Twitter</a>
		  <a href="https://plus.google.com/104073389713761582561" rel="publisher" id="google" target="_blank" title="Google-plus">Google+</a>
        </div>
      </div>
      <div id="head_wrapper">
        <div id="header">
          <div class="clearfix" id="navigation_wrapper">
            <div cm_type="navigation" id="cm_navigation">
              <xsl:apply-templates mode="separate_main" select="sitetree" />
            </div>
          </div>
		  <div id="logo_wrapper"> </div>
		  <div class="clearfix" id="subnavigation_wrapper">
        <div cm_orientation="vertical" cm_type="subnavigation" id="cm_subnavigation">
				<xsl:apply-templates mode="separate_sub" select="sitetree" >
				<xsl:with-param name="forceSub" select="true()" />
                </xsl:apply-templates>
				<div class="clearer"></div>
        </div>
      </div>
        </div>
      </div>
      <div id="keyvisual_wrapper">
        <div id="content-slider">
          <div id="slider">
					<img src="{$path_design}img/01.jpg" alt="" />
        			<img src="{$path_design}img/02.jpg" alt="" />
        			<img src="{$path_design}img/03.jpg" alt="" />
					<img src="{$path_design}img/04.jpg" alt="" />
					<img src="{$path_design}img/05.jpg" alt="" />
					<img src="{$path_design}img/06.jpg" alt="" />
					<img src="{$path_design}img/07.jpg" alt="" />
					<img src="{$path_design}img/08.jpg" alt="" />
					<img src="{$path_design}img/09.jpg" alt="" />
					<img src="{$path_design}img/10.jpg" alt="" />
					<img src="{$path_design}img/11.jpg" alt="" />
					<img src="{$path_design}img/12.jpg" alt="" />
					<img src="{$path_design}img/13.jpg" alt="" />
          </div>
        </div>
      </div>
      <div id="title_wrapper">
        <h1 cm_id="title" cm_type="title" id="title">
          <xsl:apply-templates select="sitetree/title" />
        </h1>
        <h2 cm_id="subtitle" cm_type="title" id="subtitle">
          <xsl:apply-templates select="sitetree/subtitle" />
        </h2>
      </div>
      
      <div id="content_wrapper">
        <div class="content_main" cm_maxwidth="900" cm_minwidth="900" cm_type="content" id="content_main">
          <xsl:apply-templates select="content" />
        </div>
        <div class="sidebar_wrapper">
          <div class="content_sidebar">
            <div cm_index="1" cm_scope="local" cm_type="sidebar" id="widgetbar_page_1">
              <xsl:apply-templates select="widgets/*[@cm_index = '1']" />
            </div>
            <div cm_index="1" cm_scope="global" cm_type="sidebar" id="widgetbar_site_1">
              <xsl:apply-templates select="sitetree/widgets/*[@cm_index = '1']" />
            </div>
          </div>
          <div class="content_sidebar">
            <div cm_index="2" cm_scope="local" cm_type="sidebar" id="widgetbar_page_2">
              <xsl:apply-templates select="widgets/*[@cm_index = '2']" />
            </div>
            <div cm_index="2" cm_scope="global" cm_type="sidebar" id="widgetbar_site_2">
              <xsl:apply-templates select="sitetree/widgets/*[@cm_index = '2']" />
            </div>
          </div>
        </div>
      </div>
      <div id="footer_wrapper">
        <div cm_type="footer" id="footer">
          <xsl:apply-templates select="sitetree/footer" />
        </div>
      </div>
    </div>
    <hr class="spacer_bottom" />
    <div class="cm-kv-0" cm_keyvisual_dir="KV" cm_type="keyvisual" id="keyvisual"> </div>
  </xsl:template>
</xsl:stylesheet>
<!--äöüß I18N:check:1-->

